/*
 * Decompiled with CFR 0.152.
 */
package com.orcinus.world.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.orcinus.config.ConfigHolder;
import com.orcinus.utils.FastNoiseUtils;
import com.orcinus.utils.OpenSimplexNoise;
import com.orcinus.world.carver.AbstractCarver;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class ExperimentalTunnelCarver
extends AbstractCarver<ProbabilityConfig> {
    private long seed;
    private long worldSeed;
    private OpenSimplexNoise simplexNoise;
    private OctavesNoiseGenerator caveNoise;
    private OctavesNoiseGenerator offsetNoise;
    private OctavesNoiseGenerator scaleNoise;
    private FastNoiseUtils noise;

    public ExperimentalTunnelCarver(Codec<ProbabilityConfig> codec, int maxHeight, boolean aquifers) {
        super(codec, maxHeight, aquifers);
        long seed;
        this.field_222718_j = ImmutableSet.of((Object)Blocks.field_150355_j);
        this.field_222719_k = ImmutableSet.of((Object)Fluids.field_204546_a, (Object)Fluids.field_207212_b);
        this.seed = seed = this.worldSeed;
        this.simplexNoise = new OpenSimplexNoise(this.worldSeed);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(this.worldSeed);
        this.noise = new FastNoiseUtils((int)this.worldSeed);
        this.noise.SetNoiseType(FastNoiseUtils.NoiseType.Perlin);
        this.noise.SetFrequency(0.04f);
        this.caveNoise = new OctavesNoiseGenerator(sharedseedrandom, IntStream.rangeClosed(-15, 0));
        this.offsetNoise = new OctavesNoiseGenerator(sharedseedrandom, IntStream.rangeClosed(-15, 0));
        this.scaleNoise = new OctavesNoiseGenerator(sharedseedrandom, IntStream.rangeClosed(-7, 0));
    }

    protected boolean func_227208_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double randOffsetXCoord, double startY, double randOffsetZCoord, double p_227208_14_, double p_227208_16_, BitSet carvingMask) {
        this.worldSeed = seed;
        return super.func_227208_a_(chunk, biomePos, this.worldSeed, seaLevel, chunkX, chunkZ, randOffsetXCoord, startY, randOffsetZCoord, p_227208_14_, p_227208_16_, carvingMask);
    }

    @Override
    public boolean func_225555_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int chunkX, int chunkZ, int chunkXOffset, int chunkZOffset, BitSet carvingMask, ProbabilityConfig config) {
        int noiseX;
        if (chunkX != chunkXOffset || chunkZ != chunkZOffset) {
            return false;
        }
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkStartX = chunkPos.func_180334_c();
        int chunkStartZ = chunkPos.func_180333_d();
        double[][][] noiseTerrain = new double[2][5][7];
        for (noiseX = 0; noiseX < 5; ++noiseX) {
            noiseTerrain[0][noiseX] = new double[10];
            this.sampCol(noiseTerrain[0][noiseX], chunkX * 4, chunkZ * 4 + noiseX, this.caveNoise, this.offsetNoise);
            noiseTerrain[1][noiseX] = new double[10];
        }
        for (noiseX = 0; noiseX < 4; ++noiseX) {
            int noiseZ;
            for (noiseZ = 0; noiseZ < 5; ++noiseZ) {
                this.sampCol(noiseTerrain[1][noiseZ], chunkX * 4 + noiseX + 1, chunkZ * 4 + noiseZ, this.caveNoise, this.offsetNoise);
            }
            for (noiseZ = 0; noiseZ < 4; ++noiseZ) {
                for (int noiseY = 7; noiseY >= 0; --noiseY) {
                    double x0z0y0 = noiseTerrain[0][noiseZ][noiseY];
                    double x0z1y0 = noiseTerrain[0][noiseZ + 1][noiseY];
                    double x1z0y0 = noiseTerrain[1][noiseZ][noiseY];
                    double x1z1y0 = noiseTerrain[1][noiseZ + 1][noiseY];
                    double x0z0y1 = noiseTerrain[0][noiseZ][noiseY + 1];
                    double x0z1y1 = noiseTerrain[0][noiseZ + 1][noiseY + 1];
                    double x1z0y1 = noiseTerrain[1][noiseZ][noiseY + 1];
                    double x1z1y1 = noiseTerrain[1][noiseZ + 1][noiseY + 1];
                    for (int primeY = 7; primeY >= 0; --primeY) {
                        int realY = noiseY * 8 + primeY;
                        double deltaY = (double)primeY / 9.0;
                        double x0z0 = MathHelper.func_219803_d((double)deltaY, (double)x0z0y0, (double)x0z0y1);
                        double x1z0 = MathHelper.func_219803_d((double)deltaY, (double)x1z0y0, (double)x1z0y1);
                        double x0z1 = MathHelper.func_219803_d((double)deltaY, (double)x0z1y0, (double)x0z1y1);
                        double x1z1 = MathHelper.func_219803_d((double)deltaY, (double)x1z1y0, (double)x1z1y1);
                        for (int primeX = 0; primeX < 4; ++primeX) {
                            int realX = chunkStartX + noiseX * 4 + primeX;
                            int localX = realX & 0xF;
                            double deltaX = (double)primeX / 4.0;
                            double z0 = MathHelper.func_219803_d((double)deltaX, (double)x0z0, (double)x1z0);
                            double z1 = MathHelper.func_219803_d((double)deltaX, (double)x0z1, (double)x1z1);
                            for (int primeZ = 0; primeZ < 4; ++primeZ) {
                                int realZ = chunkStartZ + noiseZ * 4 + primeZ;
                                int localZ = realZ & 0xF;
                                double deltaZ = (double)primeZ / 4.0;
                                double noise = MathHelper.func_219803_d((double)deltaZ, (double)z0, (double)z1);
                                if (realY > this.field_222720_l || !(noise < 0.0)) continue;
                                BlockPos realPos = new BlockPos(chunkX * 16 + localX, realY, chunkZ * 16 + localZ);
                                this.carveBlock(chunk, biomePos, chunkX, chunkZ, localX, localZ, rand, realY);
                            }
                        }
                    }
                }
            }
            double[][] ds = noiseTerrain[0];
            noiseTerrain[0] = noiseTerrain[1];
            noiseTerrain[1] = ds;
        }
        return true;
    }

    private void carveBlock(IChunk chunk, Function<BlockPos, Biome> biomePos, int chunkX, int chunkZ, int localX, int localZ, Random random, int y) {
        int i;
        int x = chunkX * 16 + localX;
        int z = chunkZ * 16 + localZ;
        BlockPos localPos = new BlockPos(localX, y, localZ);
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        Biome biome = biomePos.apply((BlockPos)pos);
        BlockState state = field_222715_g.getBlockState();
        if (!this.func_222707_a(chunk.func_180495_p(blockPos), chunk.func_180495_p(blockPos.func_177984_a()))) {
            return;
        }
        if (y > 50) {
            for (i = 0; i < 9; ++i) {
                if (chunk.func_180495_p(pos.func_177981_b(i)) == Blocks.field_150350_a.func_176223_P()) {
                    return;
                }
                if (chunk.func_180495_p(pos.func_177981_b(i)).func_185904_a() != Material.field_151586_h) continue;
                return;
            }
        }
        if (chunk.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            state = Blocks.field_201941_jj.func_176223_P();
            if (y > 25) {
                return;
            }
            if (y < 11) {
                return;
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()) == Blocks.field_150351_n.func_176223_P()) {
            for (i = 0; i < 3; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_196656_g.func_176223_P(), false);
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150354_m)) {
            for (i = 0; i < 3; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_150322_A.func_176223_P(), false);
            }
        }
        if (chunk.func_180495_p(pos.func_177984_a()) == Blocks.field_196611_F.func_176223_P()) {
            for (i = 0; i < 3; ++i) {
                chunk.func_177436_a(pos.func_177981_b(i), Blocks.field_180395_cM.func_176223_P(), false);
            }
        } else {
            int locX = x & 0xF;
            int locZ = z & 0xF;
            if (chunk.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h || y < this.field_222720_l && chunk.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h || locX < 15 && chunk.func_180495_p(blockPos.func_177974_f()).func_185904_a() == Material.field_151586_h || locX > 0 && chunk.func_180495_p(blockPos.func_177976_e()).func_185904_a() == Material.field_151586_h || locZ > 0 && chunk.func_180495_p(blockPos.func_177978_c()).func_185904_a() == Material.field_151586_h || locZ < 15 && chunk.func_180495_p(blockPos.func_177968_d()).func_185904_a() == Material.field_151586_h) {
                return;
            }
            if (y < 11) {
                state = Blocks.field_150353_l.func_176223_P();
            }
            if (y < 5) {
                return;
            }
            chunk.func_177436_a(blockPos, state, false);
            chunk.func_212247_j().func_205360_a((BlockPos)pos, (Object)Fluids.field_204546_a, 0);
        }
    }

    protected boolean func_222707_a(BlockState state, BlockState aboveState) {
        return state != Blocks.field_196658_i.func_176223_P() || state != Blocks.field_150346_d.func_176223_P() || super.func_222707_a(state, aboveState);
    }

    private void sampCol(double[] buffer, int x, int z, OctavesNoiseGenerator caveNoise, OctavesNoiseGenerator offsetNoise) {
        double offset = offsetNoise.func_205563_a((double)x * 200.0, 10.0, (double)z * 200.0);
        for (int y = 0; y < buffer.length; ++y) {
            buffer[y] = this.sampNoise(caveNoise, x, y, z) + this.cutOff(offset, y);
        }
    }

    private double sampNoise(OctavesNoiseGenerator caveNoise, int x, int y, int z) {
        double noise = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < 7; ++i) {
            ImprovedNoiseGenerator sampler = caveNoise.func_215463_a(i);
            double xAmplifier = this.noise.GetNoise(x, z);
            double yAmplfier = this.noise.GetNoise(x, (float)z + 69.0f);
            double zAmplifier = this.noise.GetNoise(x, (float)z + 189.0f);
            noise += sampler.func_215456_a((double)x * (Double)ConfigHolder.xzTunnelCompression.get() * amplitude + xAmplifier / 0.5, (double)y * 1.1 * (amplitude * 14.24) + yAmplfier / 0.5, (double)z * (Double)ConfigHolder.xzTunnelCompression.get() * amplitude + zAmplifier / 0.5, 0.0, 0.0) / amplitude;
            amplitude *= 0.5;
        }
        return noise *= 1.2;
    }

    private double cutOff(double offset, int y) {
        double scale = 35.0 + offset;
        double cutOff = 1.5 * (scale / (double)y * 0.5) + scale;
        return cutOff += 2.0;
    }

    @Override
    protected boolean func_222708_a(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return false;
    }

    @Override
    public boolean func_212868_a_(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return true;
    }
}

